// Purpose: Win32 Windows application  Ŭ 
// Author : ڱ
// Update : 2003/05/06
// Date   : 2003/04/28

#if defined(_WIN32) && defined(_GUI)

//
// Headers
//

#include <pesc.h>

//
// Definitions
//

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// C_Wnd ޼ ޴  Ŭ  BEGIN_MESSAGE_MAP 
// ʾҴ. 
const C_Wnd::MSDM* C_Wnd::GetMessageMap() const
    { return &C_Wnd::messageMap; }
const C_Wnd::MSDM C_Wnd::messageMap =
    { NULL, C_Wnd::rgmsd };
const C_Wnd::MSD C_Wnd::rgmsd[] = {
    ON_MESSAGE(WM_DESTROY, C_Wnd::OnDestroy)
    ON_MESSAGE(WM_NCDESTROY, C_Wnd::OnNCDestroy)
    ON_COMMAND(PESC_IDM_FILE_EXIT, C_Wnd::CmdFileExit)
    ON_COMMAND(PESC_IDM_WINDOW_TILE, C_Wnd::CmdWindowTile)
    ON_COMMAND(PESC_IDM_WINDOW_CASCADE, C_Wnd::CmdWindowCascade)
    ON_COMMAND(PESC_IDM_WINDOW_ARRANGE, C_Wnd::CmdWindowArrange)
END_MESSAGE_MAP()

HHOOK C_Wnd::m_hHook = NULL;

//
// Construction/Destruction
//

// Purpose: ڿ ʱȭѴ. 
C_Wnd::C_Wnd()
    : m_hWnd(NULL), m_hWndClient(NULL), m_edwp(edwpWindow),
    m_hMenu(NULL), m_hMenuList(NULL)
{
}

// Purpose: ڿ ȯѴ.
C_Wnd::~C_Wnd()
{
     if (NULL != m_hWnd)
    {
        WARNING("~C_Wnd", !"C_Wnd::~C_Wnd");
        bool bRet = DestroyWindow();
        WARNING("~C_Wnd", true == bRet);
    }
} 

//
// Overridables
//

// Purpose: Window ϱ  Ѵ. 
// Accepts: cs- Ϸ Window  
// Returns: true- , false-  
bool C_Wnd::PreCreateWindow(CREATESTRUCT &cs)
{
    return true;
}

// Purpose: 찡 ҸǴ ޼ ó
// Comment:
//      WM_DESTROY޼ PostQuitMessage ̿Ͽ ޼ 
//       츦   ִ. 
LRESULT C_Wnd::OnDestroy(WPARAM wParam, LPARAM lParam)
{
    if (m_hWnd == PescGetApp().m_pMainFrame->GetHandle()) ::PostQuitMessage(0);
    return 0;
}

// Purpose: 찡 ҸǴ  ޼ó 
// Comment:
//      WM_NCDESTROY޼ 찡 ı   ޼ ̹Ƿ Ŭ
//        ڵ ϰ ʿ  ڵ Ŭ Ѵ.  
LRESULT C_Wnd::OnNCDestroy(WPARAM wParam, LPARAM lParam)
{
    RemoveFromMap(m_hWnd);
    return 0;
}

// Purpose: α׷  ޴ 
LRESULT C_Wnd::CmdFileExit(WORD wNotify, HWND hwndCtrl)
{
    SendMessage(WM_CLOSE);
    return 0; 
}

// Purpose:   
LRESULT C_Wnd::CmdWindowTile(WORD wNotify, HWND hwndCtrl)
{
    SendMessageClient(WM_MDITILE);
    return 0;
}

// Purpose:   
LRESULT C_Wnd::CmdWindowCascade(WORD wNotify, HWND hwndCtrl)
{
    SendMessageClient(WM_MDICASCADE);
    return 0;
}

// Purpose:   
LRESULT C_Wnd::CmdWindowArrange(WORD wNotify, HWND hwndCtrl)
{
    SendMessageClient(WM_MDIICONARRANGE);
    return 0;
}

//
// Methods
//

// Purpose: Window ޼ Call back Լ
// Comment:
//       Window ޼ ޾ ش  Ŭ ڵ .
//      Ϲ C API α׷    ϳ Call back
//      Լ  ǳ Ŭ ̺귯 ̿Ͽ ü   
//          ش  Ŭ ޼ Ų. 
LRESULT CALLBACK C_Wnd::WndProc(HWND hWnd, UINT uMessage, WPARAM wParam,
    LPARAM lParam)
{
    //  ڵ鿡 شϴ Ŭ ´. 
    C_Wnd*  pWnd = PescGetWndMap()->GetHandle(hWnd);
    ASSERT("WndProc", NULL != pWnd);
    //TRACE2("WndProc", "%d %d", hWnd, uMessage); 

    return pWnd->DispMessage(uMessage, wParam, lParam);
}

// Purpose: Window creation hooking Լ 
// Comment:
//       츦 hookϴ  찡 Ǳ  ڵ
//      Ŭ ʿ ؾ ϱ ̴. 
LRESULT CALLBACK C_Wnd::CBTProc(int iCode, WPARAM wParam, LPARAM lParam)
{
    ASSERT("CBTProc", NULL != PescGetApp().GetWnd());
    ASSERT("CBTProc", NULL != m_hHook);
    ASSERT("CBTProc", HCBT_CREATEWND == iCode);
    ASSERT("CBTProc", 0 != wParam);
    
    //      ڸƮ óس. 
    //ASSERT(NULL != lParam);
    //LPCREATESTRUCT lpcs = ((LPCBT_CREATEWND)lParam)->lpcs;
	//ASSERT(NULL != lpcs);

    HWND    hWnd = (HWND)wParam;
    ASSERT("CBTProc", NULL == PescGetWndMap()->GetHandle(hWnd));
    PescGetWndMap()->AddHandle(hWnd, PescGetApp().GetWnd());
    PescGetWndMap()->GetHandle(hWnd)->Attach(hWnd);

    LONG oldWndProc = ::SetWindowLong(hWnd, GWL_WNDPROC, (DWORD)C_Wnd::WndProc);
    ASSERT_WIN32("CBTProc", 0 != oldWndProc);

    LRESULT lResult = CallNextHookEx(m_hHook, iCode, wParam, lParam);

    PescGetApp().SetWnd(NULL);
    BOOL bRetHook = ::UnhookWindowsHookEx(m_hHook);
    WARNING_WIN32("CBTProc", TRUE == bRetHook);
    m_hHook = NULL;

    return lResult;
}

// Purpose: ޼ شϴ Լ ȣѴ.
// Accepts: uMessage - ޼ 
//          wparam - ޼  data 
//          lparam - ޼  data
// Returns:  Լ ȯϴ 
// Comment: WndProc Ͽ ȣȴ. 
LRESULT C_Wnd::DispMessage(UINT uMessage, WPARAM wparam, LPARAM lparam)
{
    const MSDM* pMessageMap = GetMessageMap();
    for( ;NULL != pMessageMap;pMessageMap = pMessageMap->baseMsd)
    {
        // ޼ ޴  ޴ ɿ شϴ Լ Ѵ. 
        if (WM_COMMAND == uMessage)
        {
            WORD    wCommand = GET_WM_COMMAND_ID(wparam, lparam);
            int     icmd = 0;
            while(0 != pMessageMap->Msd[icmd].uMessage)
            {
                if (pMessageMap->Msd[icmd].wCommand == wCommand)
                {
                    PFNCMD pfncmd = pMessageMap->Msd[icmd].pfncmd;
                    return (this->*pfncmd)(GET_WM_COMMAND_CMD(wparam, lparam),
                                      GET_WM_COMMAND_HWND(wparam, lparam));
                }
                ++icmd;
            }
        }
        // ޼ شϴ Լ Ѵ. 
        else
        {
            int  imsd = 0;
            while(0 != pMessageMap->Msd[imsd].uMessage)
            {
                if (pMessageMap->Msd[imsd].uMessage == uMessage)
                {
                    PFNMSG pfnmsg = pMessageMap->Msd[imsd].pfnmsg;
                    return (this->*pfnmsg)(wparam, lparam);
                }
                ++imsd;
            }
        }
    }
    
    if (WM_COMMAND == uMessage && NULL != m_hWndClient)
    {
        HWND hwndChild = (HWND) SendMessageClient(WM_MDIGETACTIVE);
        if (IsWindow(hwndChild))
            ::SendMessage(hwndChild, WM_COMMAND, wparam, lparam);
    }
    
    return DispDefault(uMessage, wparam, lparam);
}

// Purpose: ⺻Լ ȣѴ.
// Accepts: uMessage - ޼ 
//          wparam - ޼  data 
//          lparam - ޼  data
// Returns:  Լ ȯϴ 
LRESULT C_Wnd::DispDefault(UINT uMessage, WPARAM wparam,
    LPARAM lparam)
{
    switch (m_edwp)
    {
        case edwpNone:
            return 0;
        case edwpWindow:
            return ::DefWindowProc(m_hWnd, uMessage, wparam, lparam);
        case edwpDialog:
            return ::DefDlgProc(m_hWnd, uMessage, wparam, lparam);
        case edwpMDIFrame:
            return ::DefFrameProc(m_hWnd, m_hWndClient, uMessage, wparam, lparam);
        case edwpMDIChild:
            return ::DefMDIChildProc(m_hWnd, uMessage, wparam, lparam);
    }
    return 0;
}

// Purpose: Window Ѵ.
// Returns: true-  
//          false-  
bool C_Wnd::CreateWindowEx(DWORD dwExStyle, LPCSTR c_lpszClassName, 
	LPCSTR c_lpszWindowName, DWORD dwStyle,
	int x, int y, int nWidth, int nHeight,
	HWND hWndParent, HMENU nIDorHMenu, LPVOID lpParam)
{
    ASSERT("CreateWindowEx", NULL == m_hWnd);
    ASSERT("CreateWindowEx", NULL != c_lpszClassName);
    ASSERT("CreateWindowEx", '\0' != *c_lpszClassName);
    ASSERT("CreateWindowEx", NULL != c_lpszWindowName);
    ASSERT("CreateWindowEx", '\0' != *c_lpszWindowName);

    CREATESTRUCT    cs;
	cs.dwExStyle = dwExStyle;          // Ȯ  Ÿ 
	cs.lpszClass = c_lpszClassName;    // Window class name
	cs.lpszName = c_lpszWindowName;    // Window name
	cs.style = dwStyle;                // Window style
	cs.x = x;          // Window ġ 
	cs.y = y;          // Window ġ 
	cs.cx = nWidth;    // Window  
	cs.cy = nHeight;   // Window  
	cs.hwndParent = hWndParent;        // θ Ǵ  Window ڵ 
	cs.hMenu = nIDorHMenu;             // ޴ ڵ Ǵ Child Window ĺ 
	cs.hInstance = PescGetInstance();  // Application instance
	cs.lpCreateParams = lpParam;       // WM_CREATE޼ lParam ޵Ǵ  

    bool bRet = PreCreateWindow(cs);
	if (false == bRet) goto cleanup;

    // ʿ  ڵ Ŭ ϱ Ͽ hookingѴ. 
    ASSERT("CreateWindowEx", NULL == m_hHook);
    m_hHook = ::SetWindowsHookEx(WH_CBT, C_Wnd::CBTProc, NULL,
        ::GetCurrentThreadId());
    WARNING_WIN32("CreateWindowEx", NULL != m_hHook);
    if (NULL == m_hHook) goto cleanup;
    ASSERT("CreateWindowEx", NULL == PescGetApp().GetWnd());
    PescGetApp().SetWnd(this);

    // MDI child window Ѵ. 
    if (WS_EX_MDICHILD & dwExStyle)
    {
        MDICREATESTRUCT mcs;
        mcs.szClass = cs.lpszClass;
        mcs.szTitle = cs.lpszName;
        mcs.hOwner = cs.hInstance;
        mcs.x =  cs.x;
        mcs.y =  cs.y;
        mcs.cx = cs.cx;
        mcs.cy = cs.cy;
        mcs.style = cs.style;
        mcs.lParam = (LONG)cs.lpCreateParams;

        m_hWnd = (HWND) ::SendMessage(cs.hwndParent, WM_MDICREATE, 0,
            (LPARAM)(LPMDICREATESTRUCT) &mcs);
    }
    else  // Ϲ window Ѵ. 
    {
    	m_hWnd = ::CreateWindowEx(cs.dwExStyle, cs.lpszClass,
	   		cs.lpszName, cs.style, cs.x, cs.y, cs.cx, cs.cy,
            cs.hwndParent, cs.hMenu, cs.hInstance, cs.lpCreateParams);
    }
    WARNING_WIN32("CreateWindowEx", NULL != m_hWnd);

    if (NULL != m_hHook)
    {
        PescGetApp().SetWnd(NULL);
        BOOL bRetHook = ::UnhookWindowsHookEx(m_hHook);
        WARNING_WIN32("CreateWindowEx", TRUE == bRetHook);
        m_hHook = NULL;
        if (FALSE == bRetHook) goto cleanup;
    }

    if (WS_EX_MDICHILD & cs.dwExStyle && WS_VISIBLE & cs.style)
    {
        bRet = BringWindowToTop();
        if (FALSE == bRet) goto cleanup;
        
		if (cs.style & WS_MINIMIZE)
			ShowWindow(SW_SHOWMINIMIZED);
		else if (cs.style & WS_MAXIMIZE)
			ShowWindow(SW_SHOWMAXIMIZED);
		else
			ShowWindow(SW_SHOWNORMAL);

        ::SendMessage(cs.hwndParent, WM_MDIREFRESHMENU, 0, 0);
    }

    return (NULL != m_hWnd);

cleanup:
    WARNING("CreateWindowEx", !"C_Wnd::CreateEx");
	return false;
}

// Purpose: Window class ü Ѵ.
// Accepts: c_lpszClassName- Ŭ̸ 
//          nClassStyle- Ŭ style
//          hCursor- Ŀ 
//          hbrBackground-  
//          hIcon-  
// Returns: true- 
//          false-  
bool C_Wnd::RegisterClass(LPCSTR c_lpszClassName, UINT nClassStyle,
    HCURSOR hCursor, HBRUSH hbrBackground, HICON hIcon)
{
    ASSERT("RegisterClass", NULL != c_lpszClassName);
    ASSERT("RegisterClass", '\0' != *c_lpszClassName);

    WNDCLASSEX  wincl;
    int         iRet;

    // ̹ Ŭ ϵǾ ִ ȮѴ.
    if (FALSE != GetClassInfoEx(PescGetInstance(), c_lpszClassName, &wincl))
        return true;

    wincl.cbSize = sizeof(WNDCLASSEX);
    wincl.style = nClassStyle;
    wincl.lpfnWndProc = DefWindowProc;      // Window message ޴ ݹԼ 
    wincl.cbClsExtra = 0;
    wincl.cbWndExtra = 0;
    wincl.hInstance = PescGetInstance();    // Application instance
    wincl.hIcon = hIcon;                    // Application icon
    wincl.hCursor = hCursor;                // Application default cursor
    wincl.hbrBackground = hbrBackground;    // Window background color
    wincl.lpszMenuName = NULL;              // Default menu
    wincl.lpszClassName = c_lpszClassName;  // Window class name
    wincl.hIconSm = hIcon;                  // Application small icon

    iRet = ::RegisterClassEx(&wincl);
    WARNING_WIN32("RegisterClass", 0 != iRet);
    return (0 != iRet);
}

// Purpose: Window class , Ŀ Բ Ѵ.
// Accepts: RegisterClass
// Returns: RegisterClass 
bool C_Wnd::RegisterClassWithIcon(LPCSTR c_lpszClassName, UINT nIDResource,
    UINT nClassStyle, HBRUSH hbrBackground)
{
    HICON   hIcon = NULL;
    HCURSOR hCursor = NULL;

    if ("RegisterClassWithIcon", 0 != nIDResource)
    {
        hIcon = ::LoadIcon(PescGetInstance(), MAKEINTRESOURCE(nIDResource));
        WARNING_WIN32("RegisterClassWithIcon", NULL != hIcon);
        hCursor = ::LoadCursor(PescGetInstance(), MAKEINTRESOURCE(nIDResource));
        WARNING_WIN32("RegisterClassWithIcon", NULL != hCursor);
    }

    if (NULL == hIcon) hIcon = ::LoadIcon(NULL, IDI_APPLICATION);
    WARNING_WIN32("RegisterClassWithIcon", NULL != hIcon);
    if (NULL == hCursor) hCursor = ::LoadCursor(NULL, IDC_ARROW);
    WARNING_WIN32("RegisterClassWithIcon", NULL != hCursor);

    return RegisterClass(c_lpszClassName, nClassStyle, hCursor,
        hbrBackground, hIcon);
}

// Purpose: Ŭ  ڵ Ѵ.
// Accepts: hWnd-  ڵ 
inline void C_Wnd::Attach(HWND hWnd)
{
    ASSERT("Attach", NULL == m_hWnd);
    ASSERT("Attach", NULL != hWnd);
    m_hWnd = hWnd;
}

inline LRESULT C_Wnd::SendMessageClient(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    ASSERT("SendMessageClient", NULL != m_hWndClient);
    return ::SendMessage(m_hWndClient, uMsg, wParam, lParam);
}
    
inline LRESULT C_Wnd::SendMessage(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    ASSERT("SendMessage", NULL != m_hWnd);
    return ::SendMessage(m_hWnd, uMsg, wParam, lParam);
}
inline bool C_Wnd::LoadMenu(UINT nIDResource)
{
    ASSERT("LoadMenu", NULL == m_hMenu);
    m_hMenu = ::LoadMenu(PescGetInstance(), MAKEINTRESOURCE(nIDResource));
    WARNING_WIN32("LoadMenu", NULL != m_hMenu);
    return (NULL != m_hMenu);
}
inline bool C_Wnd::GetSubMenu(UINT nWindowListPos)
{
    ASSERT("GetSubMenu", NULL != m_hMenu);
    m_hMenuList = ::GetSubMenu(m_hMenu, nWindowListPos);
    WARNING_WIN32("GetSubMenu", NULL != m_hMenuList);
    return (NULL != m_hMenuList);
}
inline BOOL C_Wnd::ShowWindow(int iCmdShow)
{
    ASSERT("ShowWindow", NULL != m_hWnd);
    return ::ShowWindow(m_hWnd, iCmdShow);
}
inline bool C_Wnd::UpdateWindow()
{
    ASSERT("UpdateWindow", NULL != m_hWnd);
    BOOL bRet = ::UpdateWindow(m_hWnd);
    WARNING_WIN32("UpdateWindow", TRUE == bRet);
    return (TRUE == bRet);
}
inline bool C_Wnd::DestroyWindow()
{
    ASSERT("DestroyWindow", NULL != m_hWnd);
    BOOL bRet = ::DestroyWindow(m_hWnd);
    WARNING_WIN32("DestroyWindow", TRUE == bRet);
    return (TRUE == bRet);
}
inline bool C_Wnd::GetClientRect(LPRECT lpRect)
{
    ASSERT("GetClientRect", NULL != m_hWnd);
    BOOL bRet = ::GetClientRect(m_hWnd, lpRect);
    WARNING_WIN32("GetClientRect", TRUE == bRet);
    return (TRUE == bRet);
}
inline bool C_Wnd::BringWindowToTop()
{
    ASSERT("BringWindowToTop", NULL != m_hWnd);
    BOOL bRet = ::BringWindowToTop(m_hWnd);
    WARNING_WIN32("BringWindowToTop", TRUE == bRet);
    return (TRUE == bRet);
}

inline bool C_Wnd::EnumChildWindows(WNDENUMPROC lpEnumFunc, LPARAM lParam)
{
    ASSERT("EnumChildWindows", NULL != m_hWndClient);
    BOOL bRet = ::EnumChildWindows(m_hWndClient, lpEnumFunc, lParam);
    WARNING_WIN32("EnumChildWindows", TRUE == bRet);
    return (TRUE == bRet);
}

inline HWND C_Wnd::GetWindow(UINT uCmd)
{
    ASSERT("GetWindow", NULL != m_hWnd);
    HWND hWnd = ::GetWindow(m_hWnd, uCmd);
    WARNING_WIN32("GetWindow", NULL != hWnd);
    return hWnd;
}

#endif  // _WIN32, _GUI
