// Purpose: Socket ⺻ Ŭ 
// Author : ڱ
// Update : 2003-04-30
// Date   : 2003-04-24
// Comment:
//       ⺻ Ǵ Ŭ Socket API Wrapper Լ Ѵ.
//      UNIX Blocking, Non-blocking socket Ѵ.  

#if defined(_SOCKET)

#ifndef __SOCK_H_
#define __SOCK_H_

//
// Includes
//

#include <pesc.h>

#if defined(_WIN32)
    #include <winsock2.h>

    //  Winsock 
    #define WINSOCK_VER_MAJOR   2
    #define WINSOCK_VER_MINOR   2 
#else
    #include <sys/types.h>
	#include <sys/socket.h>
	#include <unistd.h>
	#include <netinet/in.h>
    #include <arpa/inet.h>
    #include <fcntl.h>

 	#define	SOCKET_ERROR			(-1)
	#define INVALID_SOCKET  		(-1)

	#define	SOCKADDR_IN				struct sockaddr_in
	#define	SOCKET					int
	
  	#define	WSAGetLastError()		errno
    #include closesocket(hSock)     close(hSock)
	#define	ioctlsocket(a,b,c)		ioctl(a,b,c)
#endif

//
// Class
//

class C_Sock
{
// Constants, Enumerations & Structures
private:
    // Socket ּ 
    struct SockAddrIn {
        SOCKADDR_IN SockAddr;    //  ּ
        bool        bIsValid;    // ּ ȿ 
    };

public:
    // Socket  带 Ÿ  
    enum Mode {
        Blocking,
        NonBlocking     // EWOULDBLOCKó ʿ 
    };

    // Socket ¸ Ÿ 
    enum Status {
        NotConnected,
        Connected,
        Connecting      // accept, connect EWOULDBLOCK 
    };
    
// Constructors & Destructors
public:
    C_Sock();
    virtual ~C_Sock();

// Operators
public:

// Attributes
private:
    SOCKET      m_hSock;    // Socket ڵ
    Mode        m_enMode;   // Socket  
    Status      m_enStatus; // Socket 
    UINT        m_fOption;  // Socket ɼ

    SockAddrIn  m_SockAddr; // Socket ּ 

// Overridables
public:

// Methods
protected:
    // Socketɼ  
    bool ApplyOption();

public:
    //
    //  Address  
    //
    
    bool SetAddress(short nFamily, unsigned short unPort, unsigned long ulAddr);
    bool SetAddress(short nFamily, unsigned short unPort, LPCSTR c_lpszAddr);

    //   (Accept ̿Ͽ socket handle ޾ƿ ʿϴ.) 
    void SetServer(SOCKET hSock, Mode enMode = Blocking,
        Status enStatus = Connected)
    {
        ASSERT(INVALID_SOCKET != hSock);
        ASSERT(INVALID_SOCKET == m_hSock);
        m_hSock = hSock;
        m_enMode = enMode;
        m_enStatus = enStatus;
    }
    
    //
    // API Wrapper inline Լ 
    //
    
    bool Socket(int iAF, int iType, int iProtocol = 0)
	{
        ASSERT(INVALID_SOCKET == m_hSock);
        m_hSock = ::socket(iAF, iType, iProtocol);
        WARNING_SOCK(INVALID_SOCKET != m_hSock);
        return(INVALID_SOCKET != m_hSock);
    }
   	bool Ioctlsocket(long lCommand, DWORD* lpArgument)
	{
        ASSERT(INVALID_SOCKET != m_hSock);
        ASSERT(NotConnected == m_enStatus);
        int iRet = ::ioctlsocket(m_hSock, lCommand, lpArgument);
        WARNING_SOCK(SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
    bool SetSockOpt(int iOptionName, const void* lpOptionValue,	int iOptionLen,
        int iLevel = SOL_SOCKET)
	{
        ASSERT(INVALID_SOCKET != m_hSock);
        ASSERT(NotConnected == m_enStatus);
        int iRet = ::setsockopt(m_hSock, iLevel, iOptionName,
            (LPCSTR)lpOptionValue, iOptionLen);
        WARNING_SOCK(SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
	bool GetSockOpt(int iOptionName, void* lpOptionValue, int* piOptionLen,
        int iLevel = SOL_SOCKET)
	{
        ASSERT(INVALID_SOCKET != m_hSock);
        ASSERT(NotConnected == m_enStatus);
        int iRet = ::getsockopt(m_hSock, iLevel, iOptionName,
            (LPSTR)lpOptionValue, piOptionLen);
        WARNING_SOCK(SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
    bool Bind()
	{
        ASSERT(INVALID_SOCKET != m_hSock);
        ASSERT(NotConnected == m_enStatus);
        ASSERT(true == m_SockAddr.bIsValid);
        int iRet = ::bind(m_hSock, (struct sockaddr *) &m_SockAddr.SockAddr,
            sizeof(m_SockAddr.SockAddr));
        WARNING_SOCK(SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
	bool Listen(int iBacklog = SOMAXCONN)
	{
        ASSERT(INVALID_SOCKET != m_hSock);
        ASSERT(NotConnected == m_enStatus);
        ASSERT(SOMAXCONN >= iBacklog);
        int iRet = ::listen(m_hSock, iBacklog);
        WARNING_SOCK(SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
    bool Close()
    {
        ASSERT(INVALID_SOCKET != m_hSock);
        int iRet = ::closesocket(m_hSock);
        m_hSock = INVALID_SOCKET;
        WARNING_SOCK(SOCKET_ERROR != iRet);
        m_enStatus = NotConnected; 
        return(SOCKET_ERROR != iRet);
    }
    
    //
    //  Լ Non-blocking modeK 츦 ó  Ѵ.
    //

    SOCKET Accept()
    {
        ASSERT(INVALID_SOCKET != m_hSock);
        ASSERT(NotConnected == m_enStatus);
        ASSERT(true == m_SockAddr.bIsValid);
        int iAddrLen = sizeof(m_SockAddr.SockAddr);
        SOCKET hSock = ::accept(m_hSock,
            (struct sockaddr *) &m_SockAddr.SockAddr, &iAddrLen);
        WARNING_SOCK(INVALID_SOCKET != hSock);
        return hSock;
    }
    bool Connect()
	{
        ASSERT(INVALID_SOCKET != m_hSock);
        ASSERT(NotConnected == m_enStatus);
        ASSERT(true == m_SockAddr.bIsValid);
        int iRet = ::connect(m_hSock, (struct sockaddr *) &m_SockAddr.SockAddr,
            sizeof(m_SockAddr.SockAddr));
        WARNING_SOCK(SOCKET_ERROR != iRet);
        if (SOCKET_ERROR != iRet)
        {
            m_enStatus = Connected;
            return true;
        }
        return false;
    }
    int Send(const void* lpBuf, int iBufLen, int nFlags = 0)
	{
        ASSERT(Connected == m_enStatus);
        int iLen = ::send(m_hSock, (LPSTR)lpBuf, iBufLen, nFlags);
        WARNING_SOCK(SOCKET_ERROR != iLen);
        return iLen;
    }
	int Recv(void* lpBuf, int iBufLen, int nFlags = 0)
	{
        ASSERT(Connected == m_enStatus);
        int iLen = ::recv(m_hSock, (LPSTR)lpBuf, iBufLen, nFlags);
        WARNING_SOCK(SOCKET_ERROR != iLen);
        return iLen;
    }
};

#endif  // __SOCK_H_

#endif  // _SOCKET
