// Purpose: Socket ⺻ Ŭ 
// Author : ڱ
// Update : 2003-04-30
// Date   : 2003-04-24

#if defined(_SOCKET)

//
// Headers
//

#include <pesc.h> 

//
// Construction/Destruction
//

// Purpose: Ŭ ʱȭѴ. 
C_Sock::C_Sock()
    : m_enStatus(NotConnected), m_enMode(Blocking),
    m_hSock(INVALID_SOCKET), m_fOption(NULL)
{
    ::memset(&m_SockAddr, 0, sizeof(m_SockAddr));
    m_SockAddr.bIsValid = false;
}

// Purpose:  ڿ ȯѴ. 
C_Sock::~C_Sock()
{
    if (INVALID_SOCKET != m_hSock)
    {
        WARNING(!"C_Sock::~C_Sock");
        Close();
    }
}

//
// Methods
//

// Purpose: ּҸ Ѵ.
// Accepts: nFamily- sim_family
//          unPort- sin_port
//          uladdr- sin_addr.s_addr
// Returns: true- , false- 
bool C_Sock::SetAddress(short nFamily, unsigned short unPort,
    unsigned long ulAddr)
{
    m_SockAddr.SockAddr.sin_family = nFamily;
    m_SockAddr.SockAddr.sin_port = htons(unPort);
    m_SockAddr.SockAddr.sin_addr.s_addr = htonl(ulAddr);
    m_SockAddr.bIsValid = true;
    return true;
}

// Purpose: ּҸ Ѵ.
// Accepts: nFamily- sim_family
//          unPort- sin_port
//          c_lpszAddr- sin_addr.s_addr
// Returns: true- , false- 
bool C_Sock::SetAddress(short nFamily, unsigned short unPort, LPCSTR c_lpszAddr)
{
    unsigned long ulAddr = inet_addr(c_lpszAddr);
    if (INADDR_NONE == ulAddr)
    {
        WARNING(!"C_Sock::SetAddr");
        m_SockAddr.bIsValid = false;
        return false;
    }
    m_SockAddr.SockAddr.sin_family = nFamily;
    m_SockAddr.SockAddr.sin_port = htons(unPort);
    m_SockAddr.SockAddr.sin_addr.s_addr = ulAddr;
    m_SockAddr.bIsValid = true;
    return true;
}

// Purpose:  ɼ Ѵ.
// Returns: true- , false-  
bool C_Sock::ApplyOption()
{
    ASSERT(INVALID_SOCKET != m_hSock);
    ASSERT(NotConnected == m_enStatus);
    bool    bRet;

    // Non blocking带 Ѵ. 
    if (NonBlocking == m_enMode)
    {
        unsigned long ulNonBlock = 1;
        bRet = Ioctlsocket(FIONBIO, (unsigned long *) & ulNonBlock);
        if (false == bRet) goto cleanup;
    }

    return true;

cleanup:
    WARNING(!"C_Sock::SetOption");
    
    return false;
}

#endif  // _SOCKET
