// Purpose:	ASSERT & TRACE  Ŭ 
// Author : ڱ
// Update : 2003/04/23
// Date	  : 2003/04/18
// Comment:
//      C_Assert Ŭ ASSERT  TRACE  ִ Ŭ ̱ 
//      ٸ Ŭ Լ Լ ؼ ȵȴ.  ٸ Ŭ
//       ʰ Լ  ʴ´. 
//      C_Assert ü Ǿ Ѵ. 
//      C_Assert Ŭ  assert ȿ ˻Ѵ.
//		ASSERT: Լ  Parameter  ȿ Ǵϰų ݵ Ȯؾ
//          ϴ  ȿ ǴѴ.  Ѿ   ASSERT 
//             ؼ ȵȴ. ASSERT ׸忡 ȿϱ
//          ̴. ׸ ASSERT Ͽ  ۾  
//          ð ʰ α׷   ִ. ̷ ó
//          ó ؾ ϴ 쿡 ASSERT ؼ ȵȴ.
//      WARNING: ASSERT   ȿ Ǵϳ α׷
//          ؼ ȵ  Ѵ.
//      TRACE:   Ȯؾ   Ȯ̳   Ȯ 
//          Ѵ. ASSERT  ׸忡 ȿϱ 
//           뿡 ؼ LOG ؾ Ѵ.

#ifndef	__ASSERT_H_
#define	__ASSERT_H_

//
// Definitions
//

// ASSERT _DEBUG 쿡 ۵Ѵ. 
#if defined(_DEBUG)
    // ASSERT, WARNING, TRACE½ ⺻ ϴ TEXT 
	#define TEXT_ASSERT    "ASSERT"
	#define TEXT_WARNING   "WARNING"
	#define TEXT_TRACE     "TRACE"

	#define	ASSERT(f)							  if (!(f)) C_Assert::Assert(__FILE__, __LINE__, #f)
	#define	WARNING(f)			                  if (!(f)) C_Assert::Warning(__FILE__, __LINE__, TEXT_WARNING, #f)
	#define TRACE0(func, sz)					  C_Assert::Trace(__FILE__, __LINE__, func, sz)
	#define TRACE1(func, sz, ps1)				  C_Assert::Trace(__FILE__, __LINE__, func, sz, ps1)
	#define TRACE2(func, sz, ps1, ps2)			  C_Assert::Trace(__FILE__, __LINE__, func, sz, ps1, ps2)
	#define TRACE3(func, sz, ps1, ps2, ps3)		  C_Assert::Trace(__FILE__, __LINE__, func, sz, ps1, ps2, ps3)
	#define TRACE4(func, sz, ps1, ps2, ps3, ps4)  C_Assert::Trace(__FILE__, __LINE__, func, sz, ps1, ps2, ps3, ps4)

#else
	#define	ASSERT(f)
	#define	WARNING(f)
	#define TRACE0(func, sz)
	#define TRACE1(func, sz, ps1)
	#define TRACE2(func, sz, ps1, ps2)
	#define TRACE3(func, sz, ps1, ps2, ps3)
	#define TRACE4(func, sz, ps1, ps2, ps3, ps4)
#endif

#if defined(_DEBUG)

///////////////////////
// Includes
///////////////////////

#include <pesc.h>

///////////////////////
// Class
///////////////////////

class C_Assert
{
// Constants, Enumerations & Structures
private:
    static LPCSTR mc_lpszAssertFile;    // ASSERT  ϸ
    static LPCSTR mc_lpszTimeFormat;    // ð 
    static UINT   mc_uTimeBufferSize;   // ð¿  ũ 

// Constructors & Destructors
public:
	C_Assert();
	~C_Assert();

// Attributes
private:
	static FILE	*ms_pflAssert; // ASSERT ϴ File handle 
	                           //  νϽ ϴµ Ѵ. 
	
// Methods
private:
    static void   GetCurrentTm(char* szTime);
    static LPCSTR GetFileExceptPath(LPCSTR c_lpszPath);

public:
	static void Assert(LPCSTR c_lpszFile, UINT uLine, LPCSTR c_lpszContent);
	static void Warning(LPCSTR c_lpszFile, UINT uLine, LPCSTR c_lpszText,
                    LPCSTR c_lpszContent);
	static void Trace(LPCSTR c_lpszFile, UINT uLine, LPCSTR c_lpszFunc,
                    LPCSTR c_lpszFormat, ...);
};

#endif  // _DEBUG

#endif  // __ASSERT_H_
